// To parse this JSON data, do
//
//     final searchRequestResponseModel = searchRequestResponseModelFromJson(jsonString);

import 'dart:convert';

import 'package:play_lab/data/model/global/global_meassage.dart';

SearchRequestResponseModel searchRequestResponseModelFromJson(String str) => SearchRequestResponseModel.fromJson(json.decode(str));

String searchRequestResponseModelToJson(SearchRequestResponseModel data) => json.encode(data.toJson());

class SearchRequestResponseModel {
  String? remark;
  String? status;
  Message? message;
  Data? data;

  SearchRequestResponseModel({
    this.remark,
    this.status,
    this.message,
    this.data,
  });

  factory SearchRequestResponseModel.fromJson(Map<String, dynamic> json) => SearchRequestResponseModel(
        remark: json["remark"],
        status: json["status"],
        message: json["message"] == null ? null : Message.fromJson(json["message"]),
        data: json["data"] == null ? null : Data.fromJson(json["data"]),
      );

  Map<String, dynamic> toJson() => {
        "remark": remark,
        "status": status,
        "message": message?.toJson(),
        "data": data?.toJson(),
      };
}

class Data {
  List<SearchItem>? movies;
  List<SearchItem>? series;
  List<SearchItem>? allItems;

  Data({
    this.movies,
    this.series,
    this.allItems,
  });

  factory Data.fromJson(Map<String, dynamic> json) => Data(
        movies: json["movies"] == null ? [] : List<SearchItem>.from(json["movies"]!.map((x) => SearchItem.fromJson(x))),
        series: json["series"] == null ? [] : List<SearchItem>.from(json["series"]!.map((x) => SearchItem.fromJson(x))),
        allItems: json["all_items"] == null ? [] : List<SearchItem>.from(json["all_items"]!.map((x) => SearchItem.fromJson(x))),
      );

  Map<String, dynamic> toJson() => {
        "movies": movies == null ? [] : List<dynamic>.from(movies!.map((x) => x.toJson())),
        "series": series == null ? [] : List<dynamic>.from(series!.map((x) => x.toJson())),
        "all_items": allItems == null ? [] : List<dynamic>.from(allItems!.map((x) => x.toJson())),
      };
}

class SearchItem {
  String? adult;
  String? backdropPath;
  List<String>? genreIds;
  String? id;
  String? originalLanguage;
  String? originalTitle;
  String? overview;
  String? popularity;
  String? posterPath;
  String? releaseDate;
  String? title;
  String? video;
  String? voteAverage;
  String? voteCount;
  List<String>? originCountry;
  String? originalName;
  String? firstAirDate;
  String? name;

  SearchItem({
    this.adult,
    this.backdropPath,
    this.genreIds,
    this.id,
    this.originalLanguage,
    this.originalTitle,
    this.overview,
    this.popularity,
    this.posterPath,
    this.releaseDate,
    this.title,
    this.video,
    this.voteAverage,
    this.voteCount,
    this.originCountry,
    this.originalName,
    this.firstAirDate,
    this.name,
  });

  factory SearchItem.fromJson(Map<String, dynamic> json) => SearchItem(
        adult: json["adult"]?.toString(),
        backdropPath: json["backdrop_path"]?.toString(),
        genreIds: json["genre_ids"] == null ? [] : List<String>.from(json["genre_ids"]!.map((x) => x.toString())),
        id: json["id"]?.toString(),
        originalLanguage: json["original_language"]?.toString(),
        originalTitle: json["original_title"]?.toString(),
        overview: json["overview"]?.toString(),
        popularity: json["popularity"]?.toString(),
        posterPath: json["poster_path"]?.toString(),
        releaseDate: json["release_date"]?.toString(),
        title: json["title"]?.toString(),
        video: json["video"]?.toString(),
        voteAverage: json["vote_average"]?.toString(),
        voteCount: json["vote_count"]?.toString(),
        originCountry: json["origin_country"] == null ? [] : List<String>.from(json["origin_country"]!.map((x) => x.toString())),
        originalName: json["original_name"]?.toString(),
        firstAirDate: json["first_air_date"]?.toString(),
        name: json["name"]?.toString(),
      );

  Map<String, dynamic> toJson() => {
        "adult": adult,
        "backdrop_path": backdropPath,
        "genre_ids": genreIds == null ? [] : List<String>.from(genreIds!.map((x) => x)),
        "id": id,
        "original_language": originalLanguage,
        "original_title": originalTitle,
        "overview": overview,
        "popularity": popularity,
        "poster_path": posterPath,
        "release_date": releaseDate,
        "title": title,
        "video": video,
        "vote_average": voteAverage,
        "vote_count": voteCount,
        "origin_country": originCountry == null ? [] : List<String>.from(originCountry!.map((x) => x)),
        "original_name": originalName,
        "first_air_date": firstAirDate,
        "name": name,
      };
}
